*Title: Resolving "Failed to connect to database" Crashes
*sSlug: failed-to-connect-to-database

================================================================

activeCollab depends on a database where it stores all the project and other data that you enter. If it fails to connect to the database, it will send a crash report to administrator or display an error message if the system is in <{page name="debugging"}>Debug mode<{/page}>.

In case you get such an error, the following scenarios could be the cause why activeCollab has lost connection to the database:

- Although rare, it could be that **your database connection parameters or database name have been changed** from when you set up the system. To resolve this, open <{path}>config/config.php<{/path}> and update connection parameters:

<{code}>define('DB_HOST', ''); // MySQL server hostname, usually localhost
define('DB_USER', ''); // User that you are using to connect to database
define('DB_PASS', ''); // User's password
define('DB_NAME', ''); // Name of the database where activeCollab is installed<{/code}>

<p></p>
- More likely, **your database is just temporally unavailable**.

The database could be unreachable for a variety of reasons: MySQL server is down or restarting, the maximum number of open database connections has been reached and activeCollab's request to connect was rejected, etc. All of these situations are outside of the application's control and cannot be fixed by activeCollab, so the system simply ends execution and sends or displays a crash report.

If you receive the crash reports frequently, we recommend that you contact your hosting provider for assistance.